<?php
require('generate.php');   // reuse your exact image generator
require('fpdf/fpdf.php');  // FPDF library folder

// Function signature updated to accept both paths
function generateCardPdf(string $pngFrontFile, string $pngBackFile)
{
    // 2. Create 7×10 cm PDF with both images
    $pdf = new FPDF('P','mm',array(70,100)); // 70 mm × 100 mm
    $pdf->SetMargins(0,0,0);
    
    // Page 1: Front Side
    $pdf->AddPage();
    $pdf->Image($pngFrontFile, 0, 0, 70, 100);    // fit page exactly
    
    // Page 2: Back Side
    $pdf->AddPage();
    $pdf->Image($pngBackFile, 0, 0, 70, 100);    // fit page exactly

    $pdfFile = str_replace('_FRONT.png', '.pdf', $pngFrontFile);
    $pdf->Output('F', $pdfFile);             // save to disk
    return $pdfFile;
}
?>